<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Automatism extends Model 
{

    protected $table = 'automatisms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function groups()
    {
        return $this->belongsToMany('App\Models\Newletter\Group');
    }

    public function newletter()
    {
        return $this->belongsTo('App\Models\Newletter\Newsletter');
    }

    public function site()
    {
        return $this->belongsTo('App\Models\Newletter\Site');
    }

}